include "4-1_lists.dfy"

module Sorting {
    
import opened ListLibrary

ghost predicate Ordered(xs: List<int>) {
    match xs
    case Nil => true
    case Cons(x, Nil) => true
    case Cons(x, Cons(y, _)) => x <= y && Ordered(xs.tail)
}


lemma AllOrdered(xs: List<int>, i: nat, j: nat)
  requires Ordered(xs) && i <= j < Length(xs)
  ensures At(xs, i) <= At(xs, j)
  {
    if i != 0 {
        AllOrdered(xs.tail, i - 1, j - 1);
    } else if i == j {
    } else {
        AllOrdered(xs.tail, 0, j - 1);
    }
  }


ghost function Count(xs: List<int>, p: int): nat {
  match xs
  case Nil => 0
  case Cons(x, tail) =>
    if x == p then (1 + Count(tail, p)) else Count(tail, p)
}


ghost function Project(xs: List<int>, p: int): List<int> {
  match xs
  case Nil => Nil
  case Cons(x, tail) => if x == p then Cons(x, Project(tail, p)) else Project(tail, p)
}


function InsertionSort(xs: List<int>): List<int> {
  match xs
  case Nil => Nil
  case Cons(x, tail) => Insert(x, InsertionSort(tail))
}

function Insert(y: int, xs: List<int>): List<int> {
  match xs
  case Nil => Cons(y, Nil)
  case Cons(x, tail) => if y < x then Cons(y, xs) else Cons(x, Insert(y, tail))
}

lemma InsertionSortOrdered(xs: List<int>)
  ensures Ordered(InsertionSort(xs))
  {
    match xs
    case Nil =>
    case Cons(x, tail) =>  InsertOrdered(x, InsertionSort(tail));
  }

lemma InsertOrdered(y: int, xs: List<int>)
  requires Ordered(xs)
  ensures Ordered(Insert(y, xs))
{}


lemma InsertionSortSameElements(xs: List<int>, p: int)
  ensures Project(xs, p) == Project(InsertionSort(xs), p)
{
  match xs
  case Nil =>
  case Cons(x, tail) => InsertSameElements(x, InsertionSort(tail), p);
}

lemma InsertSameElements(y: int, xs: List<int>, p: int)
  ensures Project(Cons(y, xs), p) == Project(Insert(y, xs), p)
{}


lemma Stability(xs: List<int>, p: int)
  ensures Project(xs, p) == Project(InsertionSort(xs), p)
{
  InsertionSortSameElements(xs,p);
}



}