public class HuffmanNode: IComparable<HuffmanNode> {
        public byte? Symbol { get; set; }
        public int Frequency { get; set; }
        public HuffmanNode Left { get; set; }
        public HuffmanNode Right { get; set; }
        public int NodeCreationOrder { get; set; }

        public bool IsLeaf()
        {
            return Symbol.HasValue;
        }

        public int CompareTo(HuffmanNode other)
        {
            if (Frequency != other.Frequency)
                return Frequency.CompareTo(other.Frequency);

            if (Symbol.HasValue && other.Symbol.HasValue)
                return Symbol.Value.CompareTo(other.Symbol.Value);

            if (Symbol.HasValue)
                return -1;
            if (other.Symbol.HasValue)
                return 1;

            if (Frequency != other.Frequency)
                return Frequency.CompareTo(other.Frequency);

            return NodeCreationOrder.CompareTo(other.NodeCreationOrder);
        }
}