public abstract class Node : IComparable<Node> {
	public int Frequency;

	public int CompareTo(HuffmanNode other) {
		if (this.Frequency != other.Frequency) {
			return this.Frequency.CompareTo(other.Frequency);
		}
		if (this is LeafNode && other is LeafNode) {
			LeafNode leafThis = (LeafNode) this;
			LeafNode leafOther = (LeafNode) other;
			return leafThis.Value.CompareTo(leafOther.Value);
		}
		if (this is InternalNode && other is InternalNode) {
			InternalNode internalThis = (InternalNode) this;
			InternalNode internalOther = (InternalNode) other;
			return internalThis.OrderId.CompareTo(internalOther.OrderId);
		}

		if ((this is LeafNode) && (other is InternalNode)) {
			return -1;
		} else {
			return 1;
		}
	}

	public sealed class LeafNode : Node {
		public byte Value;

		public LeafNode(byte key, int value) {
			Frequency = value;
			Value = key;
		}
	}

	public sealed class InternalNode : Node {
		public Node? Left;
		public Node? Right;
		public int OrderId;

		public InternalNode(int orderId, int value, Node left, Node right) {
			Frequency = value;
			OrderId = orderId;
			Left = left;
			Right = right;
		}
	}
}