﻿namespace FarmingSimulator.Fruits;

class Apple : IFruit, IEdible
{
    public int Energy { get; init; }

    public virtual void Eat()
    {
        Console.WriteLine($"Apple eaten, player got {Energy} units of energy.");
    }
}

class GoldenApple : Apple
{
    public override void Eat()
    {
        base.Eat();
        Console.WriteLine("Golden apple increased player's luck.");
    }
}

class NoseGrowingApple : Apple
{
    public override void Eat()
    {
        base.Eat();
        Console.WriteLine("Player's nose got 100-times longer.");
    }
}

// Apple factories

abstract class ConfigurableAppleFactoryBase : IFruitFactory
{
    public required int AppleEnergy { get; init; }

    public abstract IFruit Create();
}

class AppleFactory : ConfigurableAppleFactoryBase
{
    public override IFruit Create() => new Apple { Energy = AppleEnergy };
}

class GoldenAppleFactory : ConfigurableAppleFactoryBase
{
    public override IFruit Create() => new GoldenApple { Energy = AppleEnergy };
}

class NoseGrowingAppleFactory : IFruitFactory
{
    public IFruit Create() => new NoseGrowingApple { Energy = 7 };
}
