﻿namespace FarmingSimulator.Fruits;

class Apple : IFruit, IEdible
{
    public int Energy { get; init; }
}

class GoldenApple : Apple { }

class NoseGrowingApple : Apple { }

// Apple factories

abstract class ConfigurableAppleFactoryBase : IFruitFactory
{
    public required int AppleEnergy { get; init; }

    public abstract IFruit Create();
}

class AppleFactory : ConfigurableAppleFactoryBase
{
    public override IFruit Create() => new Apple { Energy = AppleEnergy };
}

class GoldenAppleFactory : ConfigurableAppleFactoryBase
{
    public override IFruit Create() => new GoldenApple { Energy = AppleEnergy };
}

class NoseGrowingAppleFactory : IFruitFactory
{
    public IFruit Create() => new NoseGrowingApple { Energy = 7 };
}
