﻿using FarmingSimulator.Fruits;

namespace FarmingSimulator;

class EatingAlgorithm {
	public void Eat(IEdible edible) {
		Console.WriteLine($"EatingAlgorithm: Edible {edible.GetType().Name} eaten, player got {edible.Energy} units of energy.");

		// Handle special fruits:
		switch (edible) {
			case GoldenApple:
				Console.WriteLine("EatingAlgorithm: Golden apple increased player's luck.");
				break;
			case NoseGrowingApple:
				Console.WriteLine("EatingAlgorithm: Player's nose got 100-times longer.");
				break;
		}
	}
}