﻿using FarmingSimulator.Fruits;

namespace FarmingSimulator {
	// Game logic

	internal class Program {
		
		static List<Tree> CreateBasicTrees() => [
			// Apple-tree
			new Tree(
				new PeriodicSpecialFruitDispensingStrategy(
					new AppleFactory { AppleEnergy = 10 },
					new GoldenAppleFactory { AppleEnergy = 10 },
					regularFruitCountPerOneSpecial: 1
				)
			),

			// Peach-tree
			new Tree(
				new SingleFruitDispensingStrategy(
					new PeachFactory()
				)
			),

			// Frnakovnik
			new Tree(
				new SingleFruitDispensingStrategy(
					new NoseGrowingAppleFactory()
				)
			),

			// Cheap Frnakovnik
			new Tree(
				new PeriodicSpecialFruitDispensingStrategy(
					new AppleFactory { AppleEnergy = 10 },
					new NoseGrowingAppleFactory(),
					regularFruitCountPerOneSpecial: 2
				)
			)
		];

		static void Main(string[] args) {
			var trees = CreateBasicTrees();

			var eatingAlgorithm = new EatingAlgorithm();
			foreach (var tree in trees) {
				HarvestAndEatAllFruits(tree, eatingAlgorithm);
			}
		}

		static void HarvestAndEatAllFruits(Tree tree, EatingAlgorithm eatingAlgorithm) {
			var fruits = tree.Harvest();
			foreach (IFruit fruit in fruits) {
				if (fruit is IEdible edible) {
					Console.WriteLine("+++ Nice! Got edible fruit, trying to eat it ...");
					eatingAlgorithm.Eat(edible);
				} else {
					Console.WriteLine("+++ Damn! Got inedible fruit.");
				}
			}
			Console.WriteLine();
		}
	}
}
