﻿using FarmingSimulator.Fruits;

namespace FarmingSimulator;

class EatingVisitor : IEdibleVisitor {
    private void CommonVisit(IEdible edible)
    {
        Console.WriteLine($"EatingVisitor: Edible {edible.GetType().Name} eaten, player got {edible.Energy} units of energy.");
    }

    public void Visit(Apple apple) => CommonVisit(apple);

	public void Visit(GoldenApple goldenApple) {
		CommonVisit(goldenApple);
		Console.WriteLine("EatingVisitor: Golden apple increased player's luck.");
	}

	public void Visit(NoseGrowingApple noseGrowingApple) {
		CommonVisit(noseGrowingApple);
		Console.WriteLine("EatingVisitor: Player's nose got 100-times longer.");
	}
}