﻿namespace FarmingSimulator.Fruits;

class Apple : IFruit, IEdible
{
    public int Energy { get; init; }

	public virtual void Accept(IEdibleVisitor edibleVisitor) {
		edibleVisitor.Visit(this);
	}
}

class GoldenApple : Apple {
	public override void Accept(IEdibleVisitor edibleVisitor) {
		edibleVisitor.Visit(this);
	}
}

class NoseGrowingApple : Apple {
	public override void Accept(IEdibleVisitor edibleVisitor) {
		edibleVisitor.Visit(this);
	}
}

// Apple factories

abstract class ConfigurableAppleFactoryBase : IFruitFactory
{
    public required int AppleEnergy { get; init; }

    public abstract IFruit Create();
}

class AppleFactory : ConfigurableAppleFactoryBase
{
    public override IFruit Create() => new Apple { Energy = AppleEnergy };
}

class GoldenAppleFactory : ConfigurableAppleFactoryBase
{
    public override IFruit Create() => new GoldenApple { Energy = AppleEnergy };
}

class NoseGrowingAppleFactory : IFruitFactory
{
    public IFruit Create() => new NoseGrowingApple { Energy = 7 };
}
