﻿namespace FarmingSimulator.Fruits;

abstract class Apple : IFruit, IEdible
{
    public int Energy { get; init; }

	public abstract void Accept(IEdibleVisitor edibleVisitor);
}

class RegularApple : Apple {
	public override void Accept(IEdibleVisitor edibleVisitor) {
		edibleVisitor.Visit(this);
	}
}

class GoldenApple : Apple {
	public override void Accept(IEdibleVisitor edibleVisitor) {
		edibleVisitor.Visit(this);
	}
}

class NoseGrowingApple : Apple {
	public override void Accept(IEdibleVisitor edibleVisitor) {
		edibleVisitor.Visit(this);
	}
}

// Apple factories

abstract class ConfigurableAppleFactoryBase : IFruitFactory
{
    public required int AppleEnergy { get; init; }

    public abstract IFruit Create();
}

class AppleFactory : ConfigurableAppleFactoryBase
{
    public override IFruit Create() => new RegularApple { Energy = AppleEnergy };
}

class GoldenAppleFactory : ConfigurableAppleFactoryBase
{
    public override IFruit Create() => new GoldenApple { Energy = AppleEnergy };
}

class NoseGrowingAppleFactory : IFruitFactory
{
    public IFruit Create() => new NoseGrowingApple { Energy = 7 };
}
