﻿using FarmingSimulator.Fruits;

namespace FarmingSimulator;

interface IFruitDispensingStrategy {
	public IFruit DispenseFruit();
}

class SingleFruitDispensingStrategy : IFruitDispensingStrategy {
	private IFruitFactory _factory;

	public SingleFruitDispensingStrategy(IFruitFactory factory) {
		_factory = factory;
	}

	public IFruit DispenseFruit() {
		return _factory.Create();
	}
}

class PeriodicSpecialFruitDispensingStrategy : IFruitDispensingStrategy {
	private IFruitFactory _regularFruitFactory;
	private IFruitFactory _specialFruitFactory;
	private int _specialFruitModulo;
	private int _fruitsDispensed = 0;

	public PeriodicSpecialFruitDispensingStrategy(IFruitFactory regularFruitFactory, IFruitFactory specialFruitFactory, int regularFruitCountPerOneSpecial) {
		if (regularFruitCountPerOneSpecial <= 0) {
			throw new ArgumentOutOfRangeException(nameof(regularFruitCountPerOneSpecial), "Must be greater or equal to 1.");
		}
		_specialFruitModulo = regularFruitCountPerOneSpecial + 1;

		_regularFruitFactory = regularFruitFactory;
		_specialFruitFactory = specialFruitFactory;
	}

	public IFruit DispenseFruit() {
		if ((_fruitsDispensed++) % _specialFruitModulo == 0) {
			return _specialFruitFactory.Create();
		} else {
			return _regularFruitFactory.Create();
		}
	}
}
