﻿namespace FarmingSimulator.Fruits;

class Peach : IFruit, IEdible
{
    public int Energy => 8;

	public void Accept(IEdibleVisitor edibleVisitor) {
		edibleVisitor.Visit(this);
	}
}

// Peach factory

class PeachFactory : IFruitFactory
{
    public IFruit Create() => new Peach();
}
