﻿using FarmingSimulator.Fruits;

namespace FarmingSimulator {
	// Game logic

	internal class Program {
		
		static List<Tree> CreateBasicTrees() => [
			// Apple-tree
			new Tree(
				new PeriodicSpecialFruitDispensingStrategy(
					new AppleFactory { AppleEnergy = 10 },
					new GoldenAppleFactory { AppleEnergy = 10 },
					regularFruitCountPerOneSpecial: 1
				)
			),

			// Peach-tree
			new Tree(
				new SingleFruitDispensingStrategy(
					new PeachFactory()
				)
			),

			// Frnakovnik
			new Tree(
				new SingleFruitDispensingStrategy(
					new NoseGrowingAppleFactory()
				)
			),

			// Cheap Frnakovnik
			new Tree(
				new PeriodicSpecialFruitDispensingStrategy(
					new AppleFactory { AppleEnergy = 10 },
					new NoseGrowingAppleFactory(),
					regularFruitCountPerOneSpecial: 2
				)
			)
		];

		static void Main(string[] args) {
			var trees = CreateBasicTrees();

			var eatingVisitor = new EatingVisitor();
			foreach (var tree in trees) {
				HarvestAndProcessAllEdibleFruits(tree, eatingVisitor);
			}
		}

		static void HarvestAndProcessAllEdibleFruits(Tree tree, IEdibleVisitor edibleVisitor) {
			var fruits = tree.Harvest();
			foreach (IFruit fruit in fruits) {
				if (fruit is IEdible edible) {
					Console.WriteLine("+++ Nice! Got edible fruit, trying to process it ...");
					edible.Accept(edibleVisitor);
				} else {
					Console.WriteLine("+++ Damn! Got inedible fruit.");
				}
			}
			Console.WriteLine();
		}
	}
}
