﻿namespace Nezarka {

	public class Program {
		public static void Main(string[] args) {
			var s1 = DateOnly.FromDateTime(DateTime.Now).ToString();
			Console.WriteLine(s1);

			var s2 = DateOnly.FromDateTime(DateTime.Now).ToShortDateString();
			Console.WriteLine(s2);

			var s3 = DateOnly.FromDateTime(DateTime.Now).ToLongDateString();
			Console.WriteLine(s3);

			Console.WriteLine();
			new SmsNotifications.NotificationProcessor().Run();
			new Orders.OrderProcessor().Run();
		}
	}

	public struct Date {
		// TODO: Add actual fields representing stored date

		public string ToShortDateString() {
			return "20.02.2025";
		}

		public string ToLongDateString() {
			return "čtvrtek 20. února 2025";
		}
	}
}

namespace Nezarka.SmsNotifications {
	public static class DateExtensions {
		public static string ToSmsNotificationDateString(this Date date) {
			return "20.02.";
		}
	}

	public class NotificationProcessor {
		public void Run() {
			Date today = new Date();
			string message = $"Pripraveno do {today.ToSmsNotificationDateString()}";
			Console.WriteLine(message);
		}
	}
}

namespace Nezarka.Orders {
	public static class DateExtensions {
		public static string ToOrderSummaryDateString(this Date date) {
			return "20. 2. 2024";
		}
	}

	public class OrderProcessor {
		public void Run() {
			Date today = new Date();
			string message = $"Vyzvednuto {today.ToOrderSummaryDateString()}";
			Console.WriteLine(message);
		}
	}
}
