﻿namespace Nezarka {

	public class Program {
		public static void Main(string[] args) {
			var s1 = DateOnly.FromDateTime(DateTime.Now).ToString();
			Console.WriteLine(s1);

			var s2 = DateOnly.FromDateTime(DateTime.Now).ToShortDateString();
			Console.WriteLine(s2);

			var s3 = DateOnly.FromDateTime(DateTime.Now).ToLongDateString();
			Console.WriteLine(s3);

			Console.WriteLine();
			new SmsNotifications.NotificationProcessor().Run();
			new Orders.OrderProcessor().Run();
		}
	}
}

namespace Nezarka.SmsNotifications {
	public static class DateOnlyExtensions {
		public static string ToSmsNotificationDateString(this DateOnly date) {
			return $"{date.Day:D2}.{date.Month:D2}.";
		}
	}

	public class NotificationProcessor {
		public void Run() {
			var today = DateOnly.FromDateTime(DateTime.Now);
			string message = $"Pripraveno do {today.ToSmsNotificationDateString()}";
			Console.WriteLine(message);
		}
	}
}

namespace Nezarka.Orders {
	public static class DateOnlyExtensions {
		public static string ToOrderSummaryDateString(this DateOnly date) {
			return $"{date.Day}. {date.Month}. {date.Year}";
		}
	}

	public class OrderProcessor {
		public void Run() {
			var today = DateOnly.FromDateTime(DateTime.Now);
			string message = $"Vyzvednuto {today.ToOrderSummaryDateString()}";
			Console.WriteLine(message);
		}
	}
}
