.globl _start
.set noat
.set noreorder

.text
; .org 0

;
;;;
;;; Sorts 16 integers at address 0x80 using Bubble Sort
;;;
;;; This is for the single-cycle and multi-cycle MIPS data paths,
;;; therefore there are no delay slots (unlike in pipelined MIPS).
;;;
;

_start:
	addi  $a0, $zero, 16		; n = 16
	addi  $a1, $zero, 1		; one = 1 (we don't have slti yet)

outer_loop:
	slt   $t0, $a0, $a1		; $a0 < one?
	beq   $t0, $a1, outer_end	; $t0 == 1 => yes, goto outer_end

	addi  $s0, $zero, 0x80		; ptr = 0x80
	add   $s1, $zero, $zero		; i = 0
	add   $s2, $zero, $zero		; new_n = 0

inner_loop:
	slt   $t0, $s1, $a0		; i < n?
	beq   $t0, $zero, inner_end	; $t0 == 0 => no, goto inner_end

	lw    $v0, 0 ($s0)		; v0 = *ptr
	lw    $v1, 4 ($s0)		; v1 = *(ptr + 4)
	slt   $t0, $v1, $v0		; v1 < v0?
	beq   $t0, $zero, inner_next	; $t0 == 0 => v1 >= v0 branch to inner_next

	sw    $v1, 0 ($s0)		; swap
	sw    $v0, 4 ($s0)
	add   $s2, $zero, $s1		; new_n = i

inner_next:
	addi  $s0, $s0, 4		; ptr = ptr + 4
	addi  $s1, $s1, 1		; i = i + 1
	beq   $0, $0, inner_loop	; goto inner_loop (unconditional relative jump)

inner_end:
	add   $a0, $zero, $s2		; n = new_n
	beq   $0, $0, outer_loop	; goto outer_loop (unconditional relative jump)

outer_end:
	.word 0xffffffff		; invalid instruction (causes simulator to stop)
	beq    $0, $0, outer_end	; goto outer_end (unconditional relative jump)
