#include <Windows.h>

#include <stdio.h>
#include <time.h>

volatile unsigned t1Max = 0;
volatile unsigned t2Max = 0;
volatile unsigned globalMax = 0;

unsigned long __stdcall Thread1(void *param) {
	printf("Thread 1: Id(%d): Starting ...\n", GetCurrentThreadId());

	unsigned i = 1;
	while (i < 4000000000) {
		if (i > globalMax) {
			globalMax = i;
		}
		if (i > t1Max) {
			t1Max = i;
		}

		i = i + 2;
	}

	printf("Thread 1: Id(%d): Ending ...\n", GetCurrentThreadId());

	return 0;
}

unsigned long __stdcall Thread2(void *param) {
	printf("Thread 2: Id(%d): Starting ...\n", GetCurrentThreadId());

	unsigned i = 0;
	while (i < 4000000000) {
		if (i > globalMax) {
			globalMax = i;
		}
		if (i > t2Max) {
			t2Max = i;
		}
		
		i = i + 2;
	}

	printf("Thread 2: Id(%d): Ending ...\n", GetCurrentThreadId());

	return 0;
}

int main(int argc, char **argv) {
	clock_t start = clock();

	SetThreadAffinityMask(GetCurrentThread(), 1);

	HANDLE t2 = CreateThread(NULL, 0, &Thread2, NULL, CREATE_SUSPENDED, NULL);
	SetThreadAffinityMask(t2, 2);
	ResumeThread(t2);

	Thread1(0);
	WaitForSingleObject(t2, INFINITE);

	unsigned max;
	if (t1Max > t2Max) { max = t1Max; } else { max = t2Max; }

	clock_t end = clock();
	printf("Duration: %f s\n", (double) (end - start) / CLOCKS_PER_SEC);

	printf("Maximum: %u (globalni %u)\n", max, globalMax);

	CloseHandle(t2);
	return 0;
}